/* An object of type Producer spawns a thread,

   that contains a non-terminating loop (while(true)).

   With each passage of the loop a counter is incremented (count++) and

   the value is pushed onto a buffer (messages) of type Vector.

   The relevant public method of this class is given by getMessage()

   which returns the counter-value.

*/

import java.util.Vector;



class Producer extends Thread  // ------------------------------------------ Producer

{ static final int MAXQUEUE = 5; int count = 0;

  private Vector messages = new Vector();  // .............................. the buffer

  private String s, empty="EMPTY";

  public void run()

  { while( true )

    { synchronized( messages )

      { if( messages.isEmpty() )  s = empty;

        else s =  ( new Integer( messages.size() ) ).toString();

        System.out.print( ">>>" + s + ">>>" );

      }

      generateMessage( count++ );

      try{ sleep( (int)( 1000*java.lang.Math.random() ) ); }

      catch( InterruptedException e ){ e.printStackTrace(); }

  } }



  private synchronized void generateMessage( int count )

  { try

    { if( messages.size() == MAXQUEUE ) // buffer full

      { System.out.print( "producer reports: buffer full, waiting..." );

        wait(); // until consumer read from buffer (**)

      }

    }catch( InterruptedException e){ e.printStackTrace(); }

    synchronized( messages )

    { messages.addElement( new Integer(count) ); // counting detects lack in transfer

      System.out.print( " [" + count + "> " );

    }

    notify(); // Informs other waiting thread to proceed; a yield to waiting threads (*).

  } // If outcommented, the case of an undisturbed writing in the buffer will stop.



  public synchronized Integer getMessage() // ...................... called by consumer

  { try

    { if( messages.size() == 0 )

      { wait(); // until notified that buffer not empty (*)

        System.out.print(" consumer reports: buffer empty!" );

      }

    }catch( InterruptedException e){ e.printStackTrace(); }

    Integer message = (Integer)messages.firstElement();

    messages.removeElement( message );

    notify(); // in case that buffer had been full (**),

    //  if outcommented blocks on buffer full.

    return message;

  } }



/* --- The Consumer class has a main()-method which instantiates a Consumer-object,

       being also of type Thread.

   --- The run()-method contains a non-terminating loop in which the

       getMessage()-method of a Producer-object is called irregularly.

*/

class Consumer extends Thread  // ------------------------------------------ Consumer

{ Producer producer;

  Consumer( Producer p ){producer = p;}



  public void run()

  { while( true )

    { Integer message = producer.getMessage();

      System.out.println( " >" + message.toString() + "] " );

      try{ sleep( (int)( 1000*java.lang.Math.random() ) ); }

      catch( InterruptedException e ){ e.printStackTrace(); }

  } }



  public static void main( String unused[] )

  { Producer producer = new Producer();

    producer.start();

    new Consumer( producer ).start();

} }




/*
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% javac Consumer.java
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% java Consumer
>>>EMPTY>>> [0>  >0]
>>>EMPTY>>> [1>  consumer reports: buffer empty! >1]
>>>EMPTY>>> [2>  consumer reports: buffer empty! >2]
>>>EMPTY>>> [3>  >3]
>>>EMPTY>>> [4>  consumer reports: buffer empty! >4]
>>>EMPTY>>> [5> >>>1>>> [6> >>>2>>> [7> >>>3>>> [8>  >5]
>>>3>>> [9> >>>4>>> [10>  >6]
 >7]
 >8]
...
>>>2>>> [96> >>>3>>> [97>  >94]
>>>3>>> [98> >>>4>>> [99> >>>5>>>producer reports: buffer full, waiting... >95]
 [100> >>>5>>>producer reports: buffer full, waiting... >96]
 [101>  >97]
>>>4>>> [102>  >98]
>>>4>>> [103>  >99]
 >100]
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro%
*/

/*
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > javac Consumer.java
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > java Consumer
>>>EMPTY>>> [0>  >0]
>>>EMPTY>>> [1>  consumer reports: buffer empty! >1]
>>>EMPTY>>> [2>  consumer reports: buffer empty! >2]
>>>EMPTY>>> [3>  consumer reports: buffer empty! >3]
>>>EMPTY>>> [4>  consumer reports: buffer empty! >4]
>>>EMPTY>>> [5>  consumer reports: buffer empty! >5]
>>>EMPTY>>> [6>  consumer reports: buffer empty! >6]
>>>EMPTY>>> [7>  >7]
>>>EMPTY>>> [8> >>>1>>> [9>  >8]
 >9]
>>>EMPTY>>> [10>  >10]
>>>EMPTY>>> [11>  consumer reports: buffer empty! >11]
>>>EMPTY>>> [12>  >12]
>>>EMPTY>>> [13> >>>1>>> [14>  >13]
>>>1>>> [15>  >14]
>>>1>>> [16>  >15]
>>>1>>> [17> >>>2>>> [18> >>>3>>> [19> >>>4>>> [20> >>>5>>>producer reports: buffer full, waiting... >16]
 [21>  >17]
 >18]
>>>3>>> [22>  >19]
>>>3>>> [23>  >20]
 >21]
>>>2>>> [24> >>>3>>> [25> >>>4>>> [26> >>>5>>>producer reports: buffer full, waiting... >22]
 [27>  >23]
 >24]
>>>3>>> [28>  >25]
>>>3>>> [29>  >26]
^C
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading >
*/

/*
Works with Windows the same as in the examples above.
*/


/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






