/* in this example

   all explicit threading procedures

   are encapsulated in a single class: Compound

*/

class Compound implements Runnable

{

  Thread localThread;

  String aString;

  Compound( String s )

  { aString = s;

    localThread = new Thread( this );

    // as usual, "this" refers to the enclosing object

    localThread.start();

  }

  public void run()

  {

    for( int i = 0; i < 4; i++ )

    { System.out.println( aString );

      try{ Thread.sleep( 10 ); }catch( InterruptedException e ){ System.exit( 0 ); }

      //localThread.interrupt(); // Mac OS, Linux no difference

      //Thread.yield();          // Mac OS no difference, Linux main-thread ends last

} } }

public class CompoundThread

{ public static void main( String unused[] )

  { new Compound( "thread no.1 active" );

    new Compound( "thread no.2 active" );

    System.out.println( Thread.currentThread() + " main()-thread ended.");

} }





/*
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% javac CompoundThread.java
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro% java CompoundThread
thread no.1 active
thread no.2 active
Thread[main,5,main] main()-thread ended.
thread no.1 active
thread no.2 active
thread no.2 active
thread no.1 active
thread no.2 active
thread no.1 active
[localhost:~/JavaCodeFiles/Basics1/SCMultithreading] andreadipietro%
*/

/*
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > javac CompoundThread.java
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading > java CompoundThread
thread no.1 active
Thread[main,5,main] main()-thread ended.
thread no.2 active
thread no.1 active
thread no.2 active
thread no.1 active
thread no.2 active
thread no.1 active
thread no.2 active
andreadipietro@linux:~/JavaCodeFiles/Basics1/SCMultithreading >
*/

/*
C:\JavaCodeFiles\Basics1\SCMultithreading>javac CompoundThread.java

C:\JavaCodeFiles\Basics1\SCMultithreading>java CompoundThread
Thread[main,5,main] main()-thread ended.
thread no.1 active
thread no.2 active
thread no.1 active
thread no.2 active
thread no.1 active
thread no.2 active
thread no.1 active
thread no.2 active

C:\JavaCodeFiles\Basics1\SCMultithreading>
*/


/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






