/* Here the variable of primitive-type 'int' represents unsigned numbers, ranging from 0 to 255.
   The variable of primitive-type 'byte' represents signed numbers,
   the following program demonstrates that:
*/

public class IntByteCoding
{ public static void main( String unused[] )
  { for( int i = 0; i < 256; i++ )
    { byte b = (byte)i;
      System.out.println( "int " + i + "\t byte " + b );
    } // end for
  } // end method main()
} // end class

/* The piece of source-code given by the "for"-keyword
and the following pair of parenthesis and the following pair of braces
make the computer revisit the piece of code in braces, here 255-times.
The expression (byte)i transforms the 'int'-value into a 'byte'-value,
the printout can be seen below:
*/



/*
[localhost:~/JavaCodeFiles/Basics1/PrimitiveTypesMore] saintorel% javac IntByteCoding.java
[localhost:~/JavaCodeFiles/Basics1/PrimitiveTypesMore] saintorel% java IntByteCoding
int 0    byte 0
int 1    byte 1
int 2    byte 2
int 3    byte 3
...
int 125  byte 125
int 126  byte 126
int 127  byte 127
int 128  byte -128
int 129  byte -127
int 130  byte -126
...
int 251 byte -5
int 252 byte -4
int 253 byte -3
int 254 byte -2
int 255 byte -1
[localhost:~/JavaCodeFiles/Basics1/PrimitiveTypesMore] saintorel%
*/

/*
saintorel@linux:~/JavaCodeFiles/Basics1/PrimitiveTypesMore > javac IntByteCoding.java
saintorel@linux:~/JavaCodeFiles/Basics1/PrimitiveTypesMore > java IntByteCoding
int 0    byte 0
int 1    byte 1
int 2    byte 2
int 3    byte 3
...
int 125  byte 125
int 126  byte 126
int 127  byte 127
int 128  byte -128
int 129  byte -127
int 130  byte -126
...
int 252  byte -4
int 253  byte -3
int 254  byte -2
int 255  byte -1
saintorel@linux:~/JavaCodeFiles/Basics1/PrimitiveTypesMore >
*/


/*
C:\JavaCodeFiles\Basics1\PrimitiveTypesMore > javac IntByteCoding.java

C:\JavaCodeFiles\Basics1\PrimitiveTypesMore > java IntByteCoding
int 0    byte 0
int 1    byte 1
int 2    byte 2
int 3    byte 3
...
int 125  byte 125
int 126  byte 126
int 127  byte 127
int 128  byte -128
int 129  byte -127
int 130  byte -126
...
int 252  byte -4
int 253  byte -3
int 254  byte -2
int 255  byte -1

C:\JavaCodeFiles\Basics1\PrimitiveTypesMore>
*/


/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */



