public class HelloWorld
{ public static void main( String unused[] )
  { System.out.println( "Hello World!" );
  }
}
/* Comments:
--- Try compilation and running without using the keyword "public".
--- Braces mark blocks of source-code.
--- The entire piece of code marked by the Java "class"-keyword
    is given the name HelloWorld.
--- The code to be run is found inside Java's main()-method,
    this is the code 'System.out.println(...);',
    that contains the string "HelloWorld!"
    --- The modifier "public" tells that the main()-method
        is freely accessible.
    --- The modifier "static" tells the Java compiler
        that the main()-method is associated to the class,
        and not to any object derived from this class.
    --- The return type "void" tells the Java compiler that
        the main()-method does not return any value.
    --- The main()-method is called automatically
        within the Java Runtime Environment (JRE) when the
        user issues the java-command below.
    --- Space-separated strings, appended to the java-command,
        would appear as an array of name "unused".
--- Suggestion: Closing braces are positioned under opening braces,
    this ensures a better overview over block- and brace nesting.
*/

/*
[localhost:~/JavaCodeFiles/Basics1/PrimitiveTypesMore] marycosway% javac HelloWorld.java
[localhost:~/JavaCodeFiles/Basics1/PrimitiveTypesMore] marycosway%  java HelloWorld
Hello World!
[localhost:~/JavaCodeFiles/Basics1/PrimitiveTypesMore] marycosway%
*/

/*
marycosway@linux:~/JavaCodeFiles/Basics1/PrimitiveTypesMore > javac HelloWorld.java
marycosway@linux:~/JavaCodeFiles/Basics1/PrimitiveTypesMore > java HelloWorld
Hello World!
marycosway@linux:~/JavaCodeFiles/Basics1/PrimitiveTypesMore >
*/

/*
C:\JavaCodeFiles\Basics1\PrimitiveTypesMore>javac HelloWorld.java

C:\JavaCodeFiles\Basics1\PrimitiveTypesMore>java HelloWorld
Hello World!

C:\JavaCodeFiles\Basics1\PrimitiveTypesMore>
*/

/* See copyright and legal notes in the book "Charting Java", hinted at in the text-file: file:///<parentPath>/JavaCodeFiles/BASIC_INFORMATION.txt */






